<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\Rest\Routes\V2;

/**
 * @property \Twilio\Rest\Routes\V2 $v2
 * @property \Twilio\Rest\Routes\V2\PhoneNumberList $phoneNumbers
 * @property \Twilio\Rest\Routes\V2\SipDomainList $sipDomains
 * @property \Twilio\Rest\Routes\V2\TrunkList $trunks
 * @method \Twilio\Rest\Routes\V2\PhoneNumberContext phoneNumbers(string $phoneNumber)
 * @method \Twilio\Rest\Routes\V2\SipDomainContext sipDomains(string $sipDomain)
 * @method \Twilio\Rest\Routes\V2\TrunkContext trunks(string $sipTrunkDomain)
 */
class Routes extends Domain {
    protected $_v2;

    /**
     * Construct the Routes Domain
     *
     * @param Client $client Client to communicate with Twilio
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://routes.twilio.com';
    }

    /**
     * @return V2 Version v2 of routes
     */
    protected function getV2(): V2 {
        if (!$this->_v2) {
            $this->_v2 = new V2($this);
        }
        return $this->_v2;
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     * @return \Twilio\Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get(string $name) {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return \Twilio\InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments) {
        $method = 'context' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return \call_user_func_array([$this, $method], $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    protected function getPhoneNumbers(): \Twilio\Rest\Routes\V2\PhoneNumberList {
        return $this->v2->phoneNumbers;
    }

    /**
     * @param string $phoneNumber The phone number
     */
    protected function contextPhoneNumbers(string $phoneNumber): \Twilio\Rest\Routes\V2\PhoneNumberContext {
        return $this->v2->phoneNumbers($phoneNumber);
    }

    protected function getSipDomains(): \Twilio\Rest\Routes\V2\SipDomainList {
        return $this->v2->sipDomains;
    }

    /**
     * @param string $sipDomain The sip_domain
     */
    protected function contextSipDomains(string $sipDomain): \Twilio\Rest\Routes\V2\SipDomainContext {
        return $this->v2->sipDomains($sipDomain);
    }

    protected function getTrunks(): \Twilio\Rest\Routes\V2\TrunkList {
        return $this->v2->trunks;
    }

    /**
     * @param string $sipTrunkDomain The SIP Trunk
     */
    protected function contextTrunks(string $sipTrunkDomain): \Twilio\Rest\Routes\V2\TrunkContext {
        return $this->v2->trunks($sipTrunkDomain);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Routes]';
    }
}